/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.time;

import com.ibm.hwmca.base.time.ChangeTimeZoneOnlyException;
import com.ibm.hwmca.base.time.ConsoleTimeChangeInProgressException;
import com.ibm.hwmca.base.time.ConsoleTimeSetException;
import com.ibm.hwmca.base.time.ConsoleTimeSyncAttention;
import com.ibm.hwmca.base.time.ErrorIds;
import com.ibm.hwmca.base.time.MasterTimeSource;
import com.ibm.hwmca.base.time.MasterTimeSourceExistsException;
import com.ibm.hwmca.base.time.RebootRequiredException;
import com.ibm.hwmca.base.time.event.TimeChangedOnConsoleEvent;
import com.ibm.hwmca.base.time.event.TimeChangedOnConsoleListener;
import com.ibm.hwmca.base.util.BaseMessageText;
import com.ibm.hwmca.base.util.BaseMessageTitle;
import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.attn.Attention;
import com.ibm.hwmca.fw.log.FrameworkEventText;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.log.MicrocodeLogAttributes;
import com.ibm.hwmca.fw.log.SystemEventLog;
import com.ibm.hwmca.fw.managed.ClassId;
import com.ibm.hwmca.fw.managed.HMC;
import com.ibm.hwmca.fw.managed.HwmcaObject;
import com.ibm.hwmca.fw.managed.ManagedObject;
import com.ibm.hwmca.fw.managed.ManagedObjectManager;
import com.ibm.hwmca.fw.managed.ObjectId;
import com.ibm.hwmca.fw.managed.Tower;
import com.ibm.hwmca.fw.report.CompletionReport;
import com.ibm.hwmca.fw.report.CompletionReportCode;
import com.ibm.hwmca.fw.report.ReportListener;
import com.ibm.hwmca.fw.report.StepReport;
import com.ibm.hwmca.fw.shutdown.ShutdownInProcessException;
import com.ibm.hwmca.fw.shutdown.ShutdownManager;
import com.ibm.hwmca.fw.task.ProgressData;
import com.ibm.hwmca.fw.task.ProgressStartEvent;
import com.ibm.hwmca.fw.tasklet.PanelTaskletProgressListener;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.RootProcess;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.hwmca.fw.util.WorkEvent;
import com.ibm.hwmca.fw.util.WorkListener;
import com.ibm.hwmca.fw.util.WorkPerformer;
import com.ibm.hwmca.fw.util.WorkThread;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.text.NumberFormat;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.TimeZone;

public class TimeManager
implements WorkPerformer,
WorkListener,
ErrorIds {
    private static final long MAXIMUM_NON_REBOOT_TIME_DELTA = Long.MAX_VALUE;
    private static final TimeManager timeManager = new TimeManager();
    protected Object consoleTimeChangeLock = new Object();
    private Set consoleTimeSyncRequestors = new HashSet();
    private boolean consoleTimeSyncPending = false;
    protected boolean consoleTimeChangeInProgress = false;
    private Set timeChangedOnConsoleListeners = Collections.synchronizedSet(new HashSet());
    private static final String MASTER_TIME_SOURCE_INTERFACE = "com.ibm.hwmca.base.time.MasterTimeSource";
    private static final long CONSOLE_TIME_SYNC_DELAY = 10000L;
    private static final long CONSOLE_TIME_SYNC_TOLERANCE = 1000L;
    private static final long MAXIMUM_TIME_STEP = 0x3FFFFFFFFFFFFFFFL;
    private static final long CONSOLE_TIME_SET_INTERVAL = 500L;
    private static final boolean ALLOW_PROGRESS = false;
    private static final String CUSTOMIZE_DATE_TIME_COMMAND = "customizeDateTime";
    private static final String CUSTOMIZE_TIME_ZONE_COMMAND = "customizeTimeZone";
    private static final String CUSTOMIZE_TIME_ZONE_PARM_NOT_INIT = "NotInit";
    private static final String CUSTOMIZE_TIME_ZONE_PARM_GMT = "GMT";
    private static final String TEMPORARY_TIME_ZONE_FILE_NAME = "temptimezone";
    private static Class interfaceClass;
    private static ClassId[] masterClassIds;
    private static final String TRACE_MASKT = "XTODMGRT";
    private static final String TRACE_MASKF = "XTODMGRF";
    private static final String TRACE_MASKD = "XTODMGRD";

    protected TimeManager() {
        try {
            interfaceClass = Class.forName(MASTER_TIME_SOURCE_INTERFACE);
        }
        catch (ClassNotFoundException cnfe) {
            HException e = new HException(cnfe);
            new FrameworkLog(ErrorIds.LOGINFO, 3, cnfe).log();
        }
    }

    public static TimeManager getTimeManager() {
        return timeManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void requestConsoleTimeSync(HwmcaObject object) throws IllegalArgumentException {
        void var2_2;
        MasterTimeSource masterTimeSource;
        Trace.trace(TRACE_MASKT, "-> TimeManager.requestConsoleTimeSync(" + object + ")");
        if (object instanceof ManagedObject) {
            masterTimeSource = (MasterTimeSource)((ManagedObject)object).getInterfaceImpl(interfaceClass);
        } else if (object instanceof Tower) {
            masterTimeSource = (MasterTimeSource)((Tower)object).getInterfaceImpl(interfaceClass);
        } else {
            throw new IllegalArgumentException("Object is not of the proper class for setting the console's time; must be a ManagedObject or a Tower: " + object);
        }
        if (var2_2 == null) {
            throw new IllegalArgumentException("Object does not implement com.ibm.hwmca.base.time.MasterTimeSource either directly or through the interfaceImpl facility: " + object);
        }
        Trace.trace(TRACE_MASKF, "About to enter synchronized block");
        Object object2 = this.consoleTimeChangeLock;
        synchronized (object2) {
            this.consoleTimeSyncRequestors.add(object);
            if (!this.consoleTimeSyncPending) {
                Trace.trace(TRACE_MASKF, "Making a console time sync request pending");
                this.consoleTimeSyncPending = true;
                WorkThread.invokeAsync(this, this, null, "Console time sync thread");
            } else {
                Trace.trace(TRACE_MASKF, "Already a console time sync in progress; queueing this one up");
            }
        }
        Trace.trace(TRACE_MASKT, "<- TimeManager.requestConsoleTimeSync()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean requestConsoleTimeSet(Calendar newTime, PanelTaskletProgressListener progressListener, ProgressStartEvent progressStartEvent, ReportListener reportListener) throws ConsoleTimeChangeInProgressException, ChangeTimeZoneOnlyException, MasterTimeSourceExistsException, RebootRequiredException, ConsoleTimeSetException {
        Object object;
        boolean progressPanelUsed;
        Trace.trace(TRACE_MASKT, "-> TimeManager.requestConsoleTimeSet()");
        Object object2 = this.consoleTimeChangeLock;
        synchronized (object2) {
            if (this.consoleTimeChangeInProgress) {
                throw new ConsoleTimeChangeInProgressException("There is a console time change already in progress");
            }
            if (this.masterTimeSourceExists()) {
                if (this.isTimeZoneChanged(newTime)) {
                    throw new ChangeTimeZoneOnlyException("Only the time zone can be changed and this requires a reboot.");
                }
                throw new MasterTimeSourceExistsException("A master time source exists; cannot set the time manually");
            }
            if (this.isRebootRequired(newTime)) {
                throw new RebootRequiredException("A system reboot is required for this time change");
            }
            this.consoleTimeChangeInProgress = true;
        }
        try {
            progressPanelUsed = this.setConsoleTime(newTime, null, progressListener, progressStartEvent, reportListener);
            Object var8_8 = null;
            object = this.consoleTimeChangeLock;
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            Object object3 = this.consoleTimeChangeLock;
            synchronized (object3) {
                this.consoleTimeChangeInProgress = false;
                this.consoleTimeChangeLock.notifyAll();
            }
            throw throwable;
        }
        synchronized (object) {
            this.consoleTimeChangeInProgress = false;
            this.consoleTimeChangeLock.notifyAll();
        }
        Trace.trace(TRACE_MASKT, "<- TimeManager.requestConsoleTimeSet() returning " + progressPanelUsed);
        return progressPanelUsed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean setTimeChangeInProgress(boolean newValue) {
        boolean result;
        Trace.trace(TRACE_MASKT, "-> TimeManager.setTimeChangeInProgress()");
        Object object = this.consoleTimeChangeLock;
        synchronized (object) {
            if (newValue) {
                if (this.consoleTimeChangeInProgress) {
                    result = false;
                } else {
                    this.consoleTimeChangeInProgress = true;
                    result = true;
                }
            } else {
                this.consoleTimeChangeInProgress = false;
                this.consoleTimeChangeLock.notifyAll();
                result = true;
            }
        }
        Trace.trace(TRACE_MASKT, "<- TimeManager.setTimeChangeInProgress() returning " + result);
        return result;
    }

    public boolean masterTimeSourceExists() {
        return this.getMasterTimeSource() != null;
    }

    public HwmcaObject getMasterTimeSource() {
        Trace.trace(TRACE_MASKT, "-> TimeManager.getMasterTimeSource()");
        MasterTimeSource masterTimeSource = null;
        Set inventory = ManagedObjectManager.getManagedObjectManager().getInventory(masterClassIds);
        Iterator iterator = inventory.iterator();
        HwmcaObject object = null;
        while (masterTimeSource == null && iterator.hasNext()) {
            object = (HwmcaObject)iterator.next();
            try {
                masterTimeSource = this.getMasterTimeSourceImpl(object);
            }
            catch (HException e) {
                Trace.trace(TRACE_MASKF, "Unable to determine if object with id " + object.getObjectId() + " is currently a master time source, due to an exception." + "  Ignoring the object and the exception");
            }
        }
        if (masterTimeSource == null) {
            object = null;
        }
        Trace.trace(TRACE_MASKT, "<- TimeManager.getMasterTimeSource() returning " + object);
        return object;
    }

    MasterTimeSource getMasterTimeSourceImpl(HwmcaObject object) throws HException {
        Trace.trace(TRACE_MASKT, "-> TimeManager.getMasterTimeSourceImpl()");
        MasterTimeSource masterTimeSource = null;
        MasterTimeSource masterTimeSourceCandidate = null;
        if (object instanceof ManagedObject) {
            masterTimeSourceCandidate = (MasterTimeSource)((ManagedObject)object).getInterfaceImpl(interfaceClass);
        } else if (object instanceof Tower) {
            masterTimeSourceCandidate = (MasterTimeSource)((Tower)object).getInterfaceImpl(interfaceClass);
        }
        if (masterTimeSourceCandidate != null && masterTimeSourceCandidate.isMasterTimeSource(object)) {
            masterTimeSource = masterTimeSourceCandidate;
            Trace.trace(TRACE_MASKF, "getMasterTimeSourceImpl() found a master time source impl for " + object.getUIInfo().getUnlocalizedName());
        }
        Trace.trace(TRACE_MASKT, "<- TimeManager.getMasterTimeSourceImpl() returning " + masterTimeSource);
        return masterTimeSource;
    }

    protected boolean setConsoleTime(Calendar cal, String requestor) throws HException {
        return this.setConsoleTime(cal, requestor, null, null, null);
    }

    boolean setConsoleTime(Calendar cal, String requestor, PanelTaskletProgressListener progressListener, ProgressStartEvent progressStartEvent, ReportListener reportListener) throws ConsoleTimeSetException {
        Trace.trace(TRACE_MASKT, "-> TimeManager.setConsoleTime(" + cal.getTime() + "," + requestor + ")");
        Trace.trace(TRACE_MASKF, "progressListener=" + (progressListener == null ? "null" : "not null"));
        Trace.trace(TRACE_MASKF, "progressStartEvent=" + (progressStartEvent == null ? "null" : "not null"));
        Trace.trace(TRACE_MASKF, "reportListener=" + (reportListener == null ? "null" : "not null"));
        Date currentTime = new Date();
        Date newTime = cal.getTime();
        Calendar newCal = (Calendar)cal.clone();
        long delta = newTime.getTime() - currentTime.getTime();
        Trace.trace(TRACE_MASKD, "currentTime=" + currentTime);
        Trace.trace(TRACE_MASKD, "newTime=" + newTime);
        Trace.trace(TRACE_MASKD, "total delta=" + delta);
        Trace.trace(TRACE_MASKD, "newCal offset=" + newCal.get(15));
        long absoluteDelta = Math.abs(delta);
        int cnt = 0;
        long totalIterations = (absoluteDelta + 0x3FFFFFFFFFFFFFFFL - 1L) / 0x3FFFFFFFFFFFFFFFL;
        boolean useProgressPanel = false;
        boolean progressPanelStarted = false;
        boolean first = true;
        while (absoluteDelta > 1000L) {
            try {
                if (first) {
                    if (useProgressPanel) {
                        ProgressData[] progressData = progressStartEvent.getProgressData();
                        if (progressData != null && progressData.length > 0) {
                            progressData[0].setDurationTime(this.getEstimatedDuration(cal));
                        }
                        progressListener.startProgress(progressStartEvent);
                        progressPanelStarted = true;
                    }
                } else {
                    if (progressPanelStarted && reportListener != null) {
                        reportListener.intermediateReport(new StepReport(null, new BaseMessageText("TIMEPROGRESSSTEPREPORT.TEXT", new String[]{Integer.toString(cnt), Long.toString(totalIterations)})));
                        Trace.trace(TRACE_MASKF, "Just sent intermediate (step) report");
                    }
                    try {
                        Trace.trace(TRACE_MASKF, "About to sleep for 500 milliseconds before changing the time again");
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                    Trace.trace(TRACE_MASKF, "Done sleeping");
                }
                long adjustment = Math.min(0x3FFFFFFFFFFFFFFFL, absoluteDelta);
                Date nextTime = new Date();
                if (delta < 0L) {
                    nextTime.setTime(nextTime.getTime() - adjustment);
                } else {
                    nextTime.setTime(nextTime.getTime() + adjustment);
                }
                Trace.trace(TRACE_MASKD, "nextTime=" + nextTime);
                newCal.setTime(nextTime);
                currentTime = new Date();
                this.setSystemTime(newCal, requestor);
                Trace.trace(TRACE_MASKD, "Remaining delta=" + (absoluteDelta -= adjustment));
                first = false;
                ++cnt;
            }
            catch (HException he) {
                Trace.trace(TRACE_MASKF, "Caught HException " + he + "; will rethrow new ConsoleTimeSetException soon");
                ConsoleTimeSetException ctse = new ConsoleTimeSetException(he);
                if (progressPanelStarted && reportListener != null) {
                    CompletionReport cr = new CompletionReport();
                    cr.setCompletionCode(CompletionReportCode.FAIL);
                    cr.setText(new BaseMessageText("TIMEPROGRESSSETERROR.TEXT"));
                    reportListener.completeReport(cr);
                    Trace.trace(TRACE_MASKF, "Just sent failure completion report");
                    ctse.setProgressPanelUsed(true);
                } else {
                    ctse.setProgressPanelUsed(false);
                }
                throw ctse;
            }
        }
        if (progressPanelStarted && reportListener != null) {
            reportListener.intermediateReport(new StepReport(null, new BaseMessageText("TIMEPROGRESSFINALSTEPREPORT.TEXT")));
            Trace.trace(TRACE_MASKF, "Just sent the last intermediate (step) report");
        }
        if (cnt != 0) {
            try {
                Trace.trace(TRACE_MASKF, "About to sleep for 500 milliseconds after the final time change");
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            Trace.trace(TRACE_MASKF, "Done sleeping");
        }
        if (progressPanelStarted && reportListener != null) {
            CompletionReport cr = new CompletionReport();
            cr.setText(new BaseMessageText("TIMEPROGRESSSUCCESS.TEXT"));
            reportListener.completeReport(cr);
            Trace.trace(TRACE_MASKF, "Just sent success completion report");
        }
        Trace.trace(TRACE_MASKT, "<- TimeManager.setConsoleTime returning " + progressPanelStarted);
        return progressPanelStarted;
    }

    protected void setSystemTime(Calendar cal, String requestor) throws HException {
        int rc;
        Trace.trace(TRACE_MASKT, "-> TimeManger.setSystemTime(" + cal.getTime() + ")");
        NumberFormat nf = NumberFormat.getInstance();
        nf.setMinimumIntegerDigits(2);
        nf.setGroupingUsed(false);
        String month = nf.format(cal.get(2) + 1);
        String day = nf.format(cal.get(5));
        String hour = nf.format(cal.get(11));
        String minute = nf.format(cal.get(12));
        String year = nf.format(cal.get(1));
        String second = nf.format(cal.get(13));
        String cmd = "customizeDateTime " + month + day + hour + minute + year + "." + second;
        Trace.trace(TRACE_MASKF, "Command to set system time=\"" + cmd + "\"");
        Date beforeTime = new Date();
        new SystemEventLog(new FrameworkEventText(24), "BOCOLD").log();
        try {
            rc = RootProcess.executeProgram(cmd);
        }
        catch (IOException ioe) {
            Trace.trace(TRACE_MASKF, "IOException while attempting to run command: \"customizeDateTime\"");
            HException he = new HException(ioe);
            new FrameworkLog(ErrorIds.LOGINFO, 8, he).log();
            throw he;
        }
        Trace.trace(TRACE_MASKF, "Exit status from command to set system time = " + rc);
        if (rc != 0) {
            HException he = new HException("The program to set the system time failed with exit status = " + rc);
            new FrameworkLog(ErrorIds.LOGINFO, 9, he).log();
            throw he;
        }
        if (requestor == null) {
            new SystemEventLog(new FrameworkEventText(25), "BOCNEW").log();
        } else {
            new SystemEventLog(new FrameworkEventText(701, new String[]{requestor}), "BOCNEW1").log();
        }
        this.notifyTimeChangedOnConsoleListeners(beforeTime, cal.getTime());
        Trace.trace(TRACE_MASKT, "<- TimeManager.setSystemTime()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    protected void setSystemTimeZone(String zone) throws HException {
        block33: {
            block32: {
                Trace.trace("XTODMGRT", "-> TimeManger.setSystemTimeZone(" + zone + ")");
                tmpdir = new File("/tmp/");
                tmpfile = null;
                fw = null;
                bw = null;
                in = null;
                tmpFileName = null;
                bExceptionCaught = false;
                utzBundle = ResourceBundle.getBundle("com.ibm.hwmca.base.time.res.TimezoneList", new Locale("", "", ""));
                notInitTZ = (String)utzBundle.getObject("TZ0");
                tmpfile = File.createTempFile("clockFile", "", tmpdir);
                fw = new FileWriter(tmpfile);
                bw = new BufferedWriter(fw);
                Trace.trace("XTODMGRF", "   Temp File Name = " + tmpfile.getName());
                tmpFileName = tmpfile.getName();
                in = new BufferedReader(new FileReader("/etc/sysconfig/clock"));
                while ((line = in.readLine()) != null) {
                    if (line.startsWith("HWCLOCK=")) {
                        line = notInitTZ.equals(zone) ? line.substring(0, 8).trim() + "\"-u\"" : (zone.equals("GMT") ? line.substring(0, 8).trim() + "\"--localtime\"" : line.substring(0, 8).trim() + "\"-u\"");
                    } else if (line.startsWith("TIMEZONE=")) {
                        line = notInitTZ.equals(zone) != false ? line.substring(0, 9).trim() : (zone.equals("GMT") != false ? line.substring(0, 9).trim() + "\"GMT\"" : line.substring(0, 9).trim() + "\"" + zone + "\"");
                    }
                    bw.write(line, 0, line.length());
                    bw.newLine();
                }
                bw.flush();
                bw.close();
                var17_12 = null;
                if (in == null) break block32;
                in.close();
            }
            var21_14 = null;
            try {
                if (bw == null) ** GOTO lbl159
                bw.close();
            }
            catch (IOException ioe) {
                Trace.trace("XTODMGRF", "Exception caught closing file bw: " + ioe);
                if (bExceptionCaught) ** GOTO lbl159
                bExceptionCaught = true;
                he = new HException(ioe);
                new FrameworkLog(ErrorIds.LOGINFO, 14, he).log();
                throw he;
            }
            {
                catch (IOException ioe) {
                    Trace.trace("XTODMGRF", "Exception caught closing file in: " + ioe);
                    if (!bExceptionCaught) {
                        bExceptionCaught = true;
                        he = new HException(ioe);
                        new FrameworkLog(ErrorIds.LOGINFO, 16, he).log();
                        throw he;
                    }
                    var21_15 = null;
                    try {
                        if (bw == null) ** GOTO lbl159
                        bw.close();
                    }
                    catch (IOException ioe) {
                        Trace.trace("XTODMGRF", "Exception caught closing file bw: " + ioe);
                        if (!bExceptionCaught) {
                            bExceptionCaught = true;
                            he = new HException(ioe);
                            new FrameworkLog(ErrorIds.LOGINFO, 14, he).log();
                            throw he;
                        }
                        break block33;
                    }
                }
            }
            catch (Throwable var20_36) {
                block34: {
                    var21_16 = null;
                    try {
                        if (bw != null) {
                            bw.close();
                        }
                    }
                    catch (IOException ioe) {
                        Trace.trace("XTODMGRF", "Exception caught closing file bw: " + ioe);
                        if (bExceptionCaught) break block34;
                        bExceptionCaught = true;
                        he = new HException(ioe);
                        new FrameworkLog(ErrorIds.LOGINFO, 14, he).log();
                        throw he;
                    }
                }
                throw var20_36;
            }
            {
                catch (Exception e) {
                    Trace.trace("XTODMGRF", "Exception caught while creating a temporary /etc/sysconfig/clock file: " + e);
                    bExceptionCaught = true;
                    he = new HException(e);
                    new FrameworkLog(ErrorIds.LOGINFO, 13, he).log();
                    throw he;
                }
            }
            catch (Throwable var16_45) {
                block35: {
                    var17_13 = null;
                    if (in == null) break block35;
                    in.close();
                }
                var21_17 = null;
                try {
                    if (bw == null) ** GOTO lbl158
                    bw.close();
                }
                catch (IOException ioe) {
                    Trace.trace("XTODMGRF", "Exception caught closing file bw: " + ioe);
                    if (bExceptionCaught) ** GOTO lbl158
                    bExceptionCaught = true;
                    he = new HException(ioe);
                    new FrameworkLog(ErrorIds.LOGINFO, 14, he).log();
                    throw he;
                }
                {
                    catch (IOException ioe) {
                        Trace.trace("XTODMGRF", "Exception caught closing file in: " + ioe);
                        if (!bExceptionCaught) {
                            bExceptionCaught = true;
                            he = new HException(ioe);
                            new FrameworkLog(ErrorIds.LOGINFO, 16, he).log();
                            throw he;
                        }
                        var21_18 = null;
                        try {
                            if (bw == null) ** GOTO lbl158
                            bw.close();
                        }
                        catch (IOException ioe) {
                            Trace.trace("XTODMGRF", "Exception caught closing file bw: " + ioe);
                            if (!bExceptionCaught) {
                                bExceptionCaught = true;
                                he = new HException(ioe);
                                new FrameworkLog(ErrorIds.LOGINFO, 14, he).log();
                                throw he;
                            }
                        }
                    }
                }
                catch (Throwable var20_37) {
                    block36: {
                        var21_19 = null;
                        try {
                            if (bw != null) {
                                bw.close();
                            }
                        }
                        catch (IOException ioe) {
                            Trace.trace("XTODMGRF", "Exception caught closing file bw: " + ioe);
                            if (bExceptionCaught) break block36;
                            bExceptionCaught = true;
                            he = new HException(ioe);
                            new FrameworkLog(ErrorIds.LOGINFO, 14, he).log();
                            throw he;
                        }
                    }
                    throw var20_37;
                }
lbl158:
                // 6 sources

                throw var16_45;
            }
        }
        cmd = notInitTZ.equals(zone) != false ? "customizeTimeZone " + tmpFileName + " " + "NotInit" : (zone.equals("GMT") != false ? "customizeTimeZone " + tmpFileName + " " + "GMT" : "customizeTimeZone " + tmpFileName + " " + zone);
        Trace.trace("XTODMGRF", "   Command to set system timezone =\"" + cmd + "\"");
        try {
            rc = RootProcess.executeProgram(cmd);
        }
        catch (IOException ioe) {
            Trace.trace("XTODMGRF", "   IOException while attempting to run command: \"" + cmd + "\"");
            he = new HException(ioe);
            new FrameworkLog(ErrorIds.LOGINFO, 11, he).log();
            throw he;
        }
        Trace.trace("XTODMGRF", "   Exit status from command to set TimeZone = " + rc + ".  Command: \"" + cmd + "\"");
        if (rc != 0) {
            he = new HException("The program to set the system time zone failed with exit status = " + rc);
            new FrameworkLog(ErrorIds.LOGINFO, 12, he).log();
            throw he;
        }
        try {
            tmpfile.delete();
        }
        catch (SecurityException se) {
            Trace.trace("XTODMGRF", "SecurityException caught while creating a temporary /etc/sysconfig/clock file: " + se);
            he = new HException(se);
            new FrameworkLog(ErrorIds.LOGINFO, 15, he).log();
            throw he;
        }
        Trace.trace("XTODMGRT", "<- TimeManger.setSystemTimeZone()");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getSystemTimeZone() throws HException {
        Trace.trace(TRACE_MASKT, "-> TimeManger.getSystemTimeZone()");
        BufferedReader in = null;
        String zone = null;
        boolean bExceptionCaught = false;
        try {
            try {
                String line;
                in = new BufferedReader(new FileReader("/etc/sysconfig/clock"));
                while ((line = in.readLine()) != null) {
                    if (!line.startsWith("TIMEZONE=")) continue;
                    zone = line.substring(9);
                    if (zone == null || zone.equals("")) {
                        ResourceBundle utzBundle = ResourceBundle.getBundle("com.ibm.hwmca.base.time.res.TimezoneList", new Locale("", "", ""));
                        zone = (String)utzBundle.getObject("TZ0");
                        continue;
                    }
                    if (!zone.substring(0, 1).equals("\"")) continue;
                    zone = zone.substring(1, zone.length() - 1);
                }
                Object var9_7 = null;
            }
            catch (Exception e) {
                Trace.trace(TRACE_MASKF, "Exception caught while reading system clock file. " + e);
                bExceptionCaught = true;
                HException he = new HException(e);
                new FrameworkLog(ErrorIds.LOGINFO, 17, he).log();
                throw he;
            }
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException ioe) {
                Trace.trace(TRACE_MASKF, "Exception caught closing file in: " + ioe);
                if (!bExceptionCaught) {
                    bExceptionCaught = true;
                    HException he = new HException(ioe);
                    new FrameworkLog(ErrorIds.LOGINFO, 18, he).log();
                    throw he;
                }
            }
        }
        catch (Throwable throwable) {
            Object var9_8 = null;
            try {}
            catch (IOException ioe) {
                Trace.trace(TRACE_MASKF, "Exception caught closing file in: " + ioe);
                if (bExceptionCaught) throw throwable;
                bExceptionCaught = true;
                HException he = new HException(ioe);
                new FrameworkLog(ErrorIds.LOGINFO, 18, he).log();
                throw he;
            }
            if (in == null) throw throwable;
            in.close();
            throw throwable;
        }
        Trace.trace(TRACE_MASKT, "<- TimeManger.getSystemTimeZone(" + zone + ")");
        return zone;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object performWork(Object parms) {
        block24: {
            Object object;
            Iterator iterator;
            Trace.trace(TRACE_MASKT, "-> TimeManager.performWork(" + parms + ")");
            Trace.trace(TRACE_MASKF, "About to sleep for 10000 milliseconds");
            try {
                Thread.sleep(10000L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            HashSet syncRequestors = new HashSet();
            Object object2 = this.consoleTimeChangeLock;
            synchronized (object2) {
                while (this.consoleTimeChangeInProgress) {
                    try {
                        Trace.trace(TRACE_MASKF, "About to issue consoleTimeChangeLock.wait()");
                        this.consoleTimeChangeLock.wait();
                        Trace.trace(TRACE_MASKF, "consoleTimeChangeLock.wait() completed");
                    }
                    catch (InterruptedException e) {}
                }
                iterator = this.consoleTimeSyncRequestors.iterator();
                while (iterator.hasNext()) {
                    syncRequestors.add(iterator.next());
                }
                this.consoleTimeSyncRequestors.clear();
                this.consoleTimeChangeInProgress = true;
                this.consoleTimeSyncPending = false;
            }
            try {
                block23: {
                    try {
                        Trace.trace(TRACE_MASKF, "About to look for a master time source to sync the console to");
                        MasterTimeSource masterTimeSource = null;
                        iterator = syncRequestors.iterator();
                        while (masterTimeSource == null && iterator.hasNext()) {
                            HwmcaObject object3 = (HwmcaObject)iterator.next();
                            try {
                                masterTimeSource = this.getMasterTimeSourceImpl(object3);
                                if (masterTimeSource == null) continue;
                                this.syncConsoleTime(object3, masterTimeSource);
                            }
                            catch (HException e) {
                                Trace.trace(TRACE_MASKF, "An exception occurred while working with master time source " + object3.getUIInfo().getUnlocalizedName() + " and its impl " + masterTimeSource + ".  Ignoring the MasterTimeSource and the exception: " + e);
                                masterTimeSource = null;
                            }
                        }
                        if (masterTimeSource == null) {
                            Set inventory = ManagedObjectManager.getManagedObjectManager().getInventory(masterClassIds);
                            iterator = inventory.iterator();
                            while (masterTimeSource == null && iterator.hasNext()) {
                                HwmcaObject object4 = (HwmcaObject)iterator.next();
                                try {
                                    masterTimeSource = this.getMasterTimeSourceImpl(object4);
                                    if (masterTimeSource == null) continue;
                                    this.syncConsoleTime(object4, masterTimeSource);
                                }
                                catch (HException e) {
                                    Trace.trace(TRACE_MASKF, "An exception occurred while working with master time source " + object4.getUIInfo().getUnlocalizedName() + " and its impl " + masterTimeSource + ".  Ignoring the MasterTimeSource and the exception: " + e);
                                    masterTimeSource = null;
                                }
                            }
                        }
                        if (masterTimeSource != null) break block23;
                        Trace.trace(TRACE_MASKF, "Unable to set console date/time from any available master time source");
                        new FrameworkLog(ErrorIds.LOGINFO, 6).log(new MicrocodeLogAttributes(false));
                    }
                    catch (Exception e) {
                        Trace.trace(TRACE_MASKF, "Caught exception: " + e);
                        new FrameworkLog(ErrorIds.LOGINFO, 7, e);
                        Object var9_13 = null;
                        Object object3 = this.consoleTimeChangeLock;
                        synchronized (object3) {
                            this.consoleTimeChangeInProgress = false;
                            this.consoleTimeChangeLock.notifyAll();
                            break block24;
                        }
                    }
                }
                Object var9_12 = null;
                object = this.consoleTimeChangeLock;
            }
            catch (Throwable throwable) {
                Object var9_14 = null;
                Object object6 = this.consoleTimeChangeLock;
                synchronized (object6) {
                    this.consoleTimeChangeInProgress = false;
                    this.consoleTimeChangeLock.notifyAll();
                    throw throwable;
                }
            }
            synchronized (object) {
                this.consoleTimeChangeInProgress = false;
                this.consoleTimeChangeLock.notifyAll();
            }
        }
        Trace.trace(TRACE_MASKT, "<- TimeManager.performWork()");
        return null;
    }

    public void workCompleted(WorkEvent ev) {
        Trace.trace(TRACE_MASKT, "<-> TimeManager.workCompleted()");
    }

    protected void syncConsoleTime(HwmcaObject object, MasterTimeSource masterTimeSource) throws HException {
        Trace.trace(TRACE_MASKT, "-> TimeManager.syncConsoleTime()");
        String requestor = object.getUIInfo().getUnlocalizedName().toString();
        Calendar newTime = masterTimeSource.getTime(object);
        newTime = this.useHmcTimeZone(newTime);
        if (this.isRebootRequired(newTime)) {
            this.addConsoleTimeSyncAttention(requestor, object);
        } else {
            this.setConsoleTime(newTime, requestor);
        }
        Trace.trace(TRACE_MASKT, "<- TimeManager.syncConsoleTime()");
    }

    boolean syncConsoleTime(HwmcaObject object, MasterTimeSource masterTimeSource, PanelTaskletProgressListener progressListener, ProgressStartEvent progressStartEvent, ReportListener reportListener, boolean rebootOK) throws ConsoleTimeSetException, HException {
        Trace.trace(TRACE_MASKT, "-> TimeManager->syncConsoleTime()");
        Trace.trace(TRACE_MASKF, "progressListener=" + (progressListener == null ? "null" : "not null"));
        Trace.trace(TRACE_MASKF, "progressStartEvent=" + (progressStartEvent == null ? "null" : "not null"));
        Trace.trace(TRACE_MASKF, "reportListener=" + (reportListener == null ? "null" : "not null"));
        Trace.trace(TRACE_MASKF, "rebootOK=" + rebootOK);
        boolean useProgressPanel = false;
        String requestor = object.getUIInfo().getUnlocalizedName().toString();
        Calendar newTime = masterTimeSource.getTime(object);
        newTime = this.useHmcTimeZone(newTime);
        if (this.isRebootRequired(newTime)) {
            if (rebootOK) {
                this.setSystemTimeAndReboot(newTime, requestor);
            } else {
                this.addConsoleTimeSyncAttention(requestor, object);
            }
        } else {
            useProgressPanel = this.setConsoleTime(newTime, requestor, progressListener, progressStartEvent, reportListener);
        }
        Trace.trace(TRACE_MASKT, "<- TimeManager.syncConsoleTime() returning " + useProgressPanel);
        return useProgressPanel;
    }

    public Calendar useHmcTimeZone(Calendar c) throws HException {
        Trace.trace(TRACE_MASKT, "-> TimeManager.useHmcTimeZone()");
        Trace.trace(TRACE_MASKF, "   Before: TimeZone is " + c.getTimeZone());
        Trace.trace(TRACE_MASKF, "   Before: Time is " + c);
        Trace.trace(TRACE_MASKF, "   Before: Time is " + c.getTime());
        c.setTimeZone(TimeZone.getTimeZone(this.getSystemTimeZone()));
        Trace.trace(TRACE_MASKF, "   After: TimeZone is " + c.getTimeZone());
        Trace.trace(TRACE_MASKF, "   After: Time is " + c);
        Trace.trace(TRACE_MASKF, "   After: Time is " + c.getTime());
        Trace.trace(TRACE_MASKT, "<- TimeManager.useHmcTimeZone()");
        return c;
    }

    void addConsoleTimeSyncAttention(String requestor, HwmcaObject object) {
        Attention attn;
        Trace.trace(TRACE_MASKT, "-> TimeManager.addConsoleTimeSyncAttention(" + requestor + ")");
        ObjectId masterId = object.getObjectId();
        HMC hmc = HMC.getHMC();
        List attns = hmc.getAttentions();
        Iterator it = attns.iterator();
        boolean found = false;
        while (it.hasNext()) {
            attn = (Attention)it.next();
            if (!(attn instanceof ConsoleTimeSyncAttention) || !((ConsoleTimeSyncAttention)attn).getMasterTimeSourceObjectId().equals(masterId)) continue;
            Trace.trace(TRACE_MASKF, "There is already a ConsoleTimeSyncAttention for " + requestor);
            found = true;
            break;
        }
        if (!found) {
            attn = new ConsoleTimeSyncAttention(hmc.getObjectId(), (LocalizableText)new BaseMessageTitle("TIMEATTN.TITLE", new String[]{requestor}), masterId);
            hmc.addAttention(attn);
        }
        Trace.trace(TRACE_MASKT, "<- TimeManager.addConsoleTimeSyncAttention()");
    }

    protected boolean isTimeZoneChanged(Calendar newTime) {
        boolean answer = true;
        try {
            answer = !newTime.getTimeZone().getID().equals(this.getSystemTimeZone());
        }
        catch (HException hException) {
            // empty catch block
        }
        Trace.trace(TRACE_MASKT, "<-> TimeManager.isTimeZoneChanged() returning " + answer);
        return answer;
    }

    protected boolean isRebootRequired(Calendar newTime) {
        boolean answer;
        boolean bl = answer = Math.abs(new Date().getTime() - newTime.getTime().getTime()) > Long.MAX_VALUE;
        if (!answer) {
            answer = this.isTimeZoneChanged(newTime);
        }
        Trace.trace(TRACE_MASKT, "<-> TimeManager.isRebootRequired() returning " + answer);
        return answer;
    }

    protected void setSystemTimeAndReboot(Calendar newTime, String requestor) throws HException {
        String newTimeZone = newTime.getTimeZone().getID();
        if (!newTimeZone.equals(this.getSystemTimeZone())) {
            this.setSystemTimeZone(newTimeZone);
        }
        if (!this.masterTimeSourceExists()) {
            this.setSystemTime(newTime, requestor);
        }
        this.requestReboot();
    }

    protected void requestReboot() {
        Trace.trace(TRACE_MASKT, "-> TimeManager.requestReboot()");
        try {
            Trace.trace(TRACE_MASKF, "Requesting a console restart now!");
            ShutdownManager.restartConsole(new BaseMessageTitle("TIMERESTART.TITLE"), new BaseMessageText("TIMERESTART.TEXT"), null);
        }
        catch (ShutdownInProcessException sipe) {
            Trace.trace(TRACE_MASKF, "There is a pending restart request.");
        }
        Trace.trace(TRACE_MASKT, "<- TimeManager.requestReboot()");
    }

    protected long getEstimatedDuration(Calendar newTime) {
        long answer = Math.abs(new Date().getTime() - newTime.getTime().getTime()) / 0x3FFFFFFFFFFFFFFFL * 500L / 1000L + 0L;
        Trace.trace(TRACE_MASKT, "<-> TimeManager.getEstimatedDuration() returning " + answer);
        return answer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTimeChangedOnConsoleListener(TimeChangedOnConsoleListener listener) {
        Trace.trace(TRACE_MASKT, "-> TimeManager.addTimeChangedOnConsoleListener() adding " + listener);
        if (listener == null) {
            throw new IllegalArgumentException("Input TimeChangedOnConsoleListener object is null");
        }
        Set set = this.timeChangedOnConsoleListeners;
        synchronized (set) {
            this.timeChangedOnConsoleListeners.add(listener);
        }
        Trace.trace(TRACE_MASKT, "<- TimeManager.addTimeChangedOnConsoleListener()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTimeChangedOnConsoleListener(TimeChangedOnConsoleListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Input TimeChangedOnConsoleListener object is null");
        }
        Set set = this.timeChangedOnConsoleListeners;
        synchronized (set) {
            this.timeChangedOnConsoleListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyTimeChangedOnConsoleListeners(Date oldTime, Date newTime) {
        Trace.trace(TRACE_MASKT, "-> TimeManager.notifyTimeChangedOnConsoleListeners()");
        Set set = this.timeChangedOnConsoleListeners;
        synchronized (set) {
            Iterator iterator = this.timeChangedOnConsoleListeners.iterator();
            TimeChangedOnConsoleEvent event = new TimeChangedOnConsoleEvent(this, oldTime, newTime);
            while (iterator.hasNext()) {
                TimeChangedOnConsoleListener listener = (TimeChangedOnConsoleListener)iterator.next();
                Trace.trace(TRACE_MASKF, "About to raise event to listener: " + listener);
                listener.timeChangedOnConsole(event);
            }
        }
        Trace.trace(TRACE_MASKT, "<- TimeManager.notifyTimeChangedOnConsoleListeners()");
    }

    public MasterTimeSource getMasterTimeSourceImpl_TESTONLY(HwmcaObject object) throws HException {
        return this.getMasterTimeSourceImpl(object);
    }

    static {
        masterClassIds = new ClassId[]{new ClassId("com.ibm.hwmca.fw.managed.ManagedObject"), new ClassId("com.ibm.hwmca.fw.managed.Tower")};
    }
}

